import time
from typing import Dict


class Debounce:
    def __init__(self):
        self._last: Dict[str, float] = {}

    def hit(self, key: str, window: float = 0.7) -> bool:
        """Returns True if should BLOCK (too soon)."""
        now = time.time()
        last = self._last.get(key, 0)
        if now - last < window:
            return True
        self._last[key] = now
        return False


debounce = Debounce()
