import time
from typing import Dict


class UserActionLock:
    """Simple in-memory lock to prevent multi-click + concurrent actions per user."""

    def __init__(self):
        self._locks: Dict[int, float] = {}

    def locked(self, user_id: int) -> bool:
        now = time.time()
        ts = self._locks.get(user_id)
        if not ts:
            return False
        # auto expire after 3 seconds
        if now - ts > 3:
            self._locks.pop(user_id, None)
            return False
        return True

    def acquire(self, user_id: int):
        self._locks[user_id] = time.time()

    def release(self, user_id: int):
        self._locks.pop(user_id, None)


user_lock = UserActionLock()
