from aiogram.filters import BaseFilter
from aiogram.types import Message, CallbackQuery
from repositories.users_repo import users_repo

class ModeFilter(BaseFilter):
    def __init__(self, mode: str):
        self.mode = mode

    async def __call__(self, event: Message | CallbackQuery) -> bool:
        uid = event.from_user.id
        cur = await users_repo.get_mode(uid)
        return cur == self.mode
