import re

_FA_EN_TRANS = str.maketrans("۰۱۲۳۴۵۶۷۸۹٠١٢٣٤٥٦٧٨٩", "01234567890123456789")


def fa_to_en_digits(s: str) -> str:
    return (s or "").translate(_FA_EN_TRANS)


def only_digits(s: str) -> str:
    return re.sub(r"[^0-9]", "", fa_to_en_digits(s or ""))


def format_money(n: int) -> str:
    try:
        return f"{int(n):,}"
    except Exception:
        return str(n)
