from repositories.users_repo import users_repo
from repositories.sellers_repo import sellers_repo
from config import settings


class RoleService:
    async def can_enter_seller_mode(self, user_id:int)->bool:
        s = await sellers_repo.get_seller(user_id)
        return bool(s and s.get('status')=='active')

    async def get_effective_role(self, user_id: int) -> str:
        if user_id in settings.ADMIN_IDS:
            return "admin"
        mode = await users_repo.get_mode(user_id)
        if mode == "seller":
            ok = await sellers_repo.is_approved(user_id)
            return "seller" if ok else "buyer"
        return "buyer"

    async def can_be_seller(self, user_id: int) -> bool:
        return await sellers_repo.is_approved(user_id)

    async def get_user_mode(self, user_id: int) -> str:
        return await users_repo.get_mode(user_id)

    async def set_mode(self, user_id: int, mode: str):
        return await users_repo.set_mode(user_id, mode)

    async def set_user_mode(self, user_id: int, mode: str):
        return await users_repo.set_mode(user_id, mode)


role_service = RoleService()
