
from repositories.orders_repo import get_active_order

def next_step(order:dict):
    st = (order.get("status") or "").lower()
    if st == "pending_payment":
        return "receipt"
    if st == "accepted":
        return "location"
    if st == "ready_to_ship":
        return "address"
    return None

def order_caption(order:dict):
    return (
        f"📦 <b>سفارش #{order['id']}</b>\n"
        f"وضعیت: <b>{order.get('status')}</b>\n"
        f"تعداد: <b>{order.get('qty')}</b>\n"
        f"مبلغ: <b>{int(order.get('total_price') or 0):,}</b> تومان\n"
    )

async def get_active(buyer_id:int):
    return await get_active_order(buyer_id)
