
from repositories.needs_repo import needs_repo
from repositories.need_offers_repo import need_offers_repo

class NeedService:
    async def get_open_needs(self, page:int=1, per_page:int=6):
        rows, total = await needs_repo.get_open_needs(page=page, per_page=per_page)
        pages = max(1, (total + per_page - 1)//per_page)
        return {"rows": rows, "total": total, "pages": pages}

    async def get_need(self, need_id:int):
        return await needs_repo.get_need(need_id)

    async def create_offer(self, need_id:int, seller_id:int, photo_file_id:str, price:int, caption:str|None):
        return await need_offers_repo.create_offer(need_id, seller_id, photo_file_id, price, caption)

need_service = NeedService()
