
import math
from repositories.flowers_repo import (
    list_marketplace, get_flower, list_seller_flowers,
    set_flower_active, delete_flower, update_flower_stock, update_flower_price,
    search_flowers_by_keyword
)
from utils.digits import format_money


def flower_caption(f: dict, compact: bool=False) -> str:
    price = format_money(int(f.get("price_toman") or 0))
    stock = int(f.get("stock") or 0)
    size = f.get("size") or "-"
    shop = f.get("shop_name") or "فروشنده"
    if compact:
        return (
            f"🌸 <b>{f.get('name')}</b>\n"
            f"💰 {price} تومان\n"
            f"📦 موجودی: <b>{stock}</b>\n"
            f"📏 سایز: <b>{size}</b>\n"
            f"🏪 {shop}"
        )
    return (
        f"🌸 <b>{f.get('name')}</b>\n"
        f"🏪 فروشنده: <b>{shop}</b>\n"
        f"📏 سایز: <b>{size}</b>\n"
        f"📦 موجودی: <b>{stock}</b>\n"
        f"💰 قیمت: <b>{price}</b> تومان"
    )


async def get_marketplace_page(page: int = 1, per_page: int = 6):
    rows, pages = await list_marketplace(page, per_page)
    total = len(rows)
    return rows, total, pages


async def get_search_page(*args, **kwargs):
    # placeholder for future advanced search
    return await get_marketplace_page(page=kwargs.get('page',1), per_page=kwargs.get('per_page',6))


async def get_similar_page(name_key: str, page: int = 1, per_page: int = 10):
    rows, pages = await search_flowers_by_keyword(name_key, page, per_page)
    total = len(rows)
    return rows, total, pages


class ListingService:
    flower_caption = staticmethod(flower_caption)

    async def get_marketplace_page(self, page:int=1, per_page:int=6):
        return await get_marketplace_page(page, per_page)

    async def get_seller_listings(self, seller_id:int, page:int=1, per_page:int=6):
        rows, total, pages = await list_seller_flowers(seller_id, page, per_page)
        return {"rows": rows, "total": total, "pages": pages}

    async def get_flower(self, flower_id:int):
        return await get_flower(flower_id)

    async def set_active(self, flower_id:int, is_active:int):
        return await set_flower_active(flower_id, is_active)

    async def delete_flower(self, flower_id:int):
        return await delete_flower(flower_id)

    async def update_stock(self, flower_id:int, stock:int):
        return await update_flower_stock(flower_id, stock)

    async def update_price(self, flower_id:int, price:int):
        return await update_flower_price(flower_id, price)


listing_service = ListingService()
