import asyncio
from db import init_db
from scheduler import start_scheduler
from bot_core import start_bot
from utils.log import setup_logging

async def main():
    setup_logging()
    await init_db()
    start_scheduler()
    await start_bot()

if __name__ == "__main__":
    asyncio.run(main())
