from db import fetchone, execute


class UsersRepo:
    async def ensure_user(self, user_id: int):
        await execute(
            "INSERT IGNORE INTO users_v7(user_id, mode, created_at) VALUES(%s,'buyer',NOW())",
            (user_id,)
        )

    async def get_mode(self, user_id: int) -> str:
        row = await fetchone("SELECT mode FROM users_v7 WHERE user_id=%s", (user_id,))
        if not row:
            await self.ensure_user(user_id)
            return "buyer"
        return row.get("mode") or "buyer"

    async def get_phone(self, user_id: int):
        row = await fetchone("SELECT phone FROM users_v7 WHERE user_id=%s", (user_id,))
        return row.get("phone") if row else None

    async def set_phone(self, user_id: int, phone: str):
        await self.ensure_user(user_id)
        await execute("UPDATE users_v7 SET phone=%s WHERE user_id=%s", (phone, user_id))

    async def set_mode(self, user_id: int, mode: str):
        await self.ensure_user(user_id)
        await execute("UPDATE users_v7 SET mode=%s WHERE user_id=%s", (mode, user_id))


users_repo = UsersRepo()
