from db import fetchone, fetchall, execute


class SellersRepo:
    async def exists(self, user_id: int) -> bool:
        row = await fetchone("SELECT user_id FROM sellers WHERE user_id=%s", (user_id,))
        return bool(row)

    async def is_approved(self, user_id: int) -> bool:
        row = await fetchone("SELECT status FROM sellers WHERE user_id=%s", (user_id,))
        return bool(row and row.get("status") == "active")

    async def get_seller(self, user_id: int):
        return await fetchone("SELECT * FROM sellers WHERE user_id=%s", (user_id,))

    async def set_phone(self, user_id: int, phone: str):
        await execute("UPDATE sellers SET phone=%s WHERE user_id=%s", (phone, user_id))

    async def set_pending(self, user_id: int, shop_name: str, city: str, card_number: str, card_owner: str, phone: str | None = None):
        await execute(
            "INSERT INTO sellers(user_id, shop_name, city, card_number, card_owner, phone, status, created_at) "
            "VALUES(%s,%s,%s,%s,%s,%s,'pending',NOW()) "
            "ON DUPLICATE KEY UPDATE shop_name=VALUES(shop_name), city=VALUES(city), card_number=VALUES(card_number), "
            "card_owner=VALUES(card_owner), phone=VALUES(phone), status='pending'",
            (user_id, shop_name, city, card_number, card_owner, phone)
        )

    async def approve(self, user_id: int):
        await execute("UPDATE sellers SET status='active' WHERE user_id=%s", (user_id,))

    async def reject(self, user_id: int):
        await execute("UPDATE sellers SET status='rejected' WHERE user_id=%s", (user_id,))

    async def list_pending(self, limit: int = 50):
        return await fetchall("SELECT * FROM sellers WHERE status='pending' ORDER BY created_at DESC LIMIT %s", (limit,))

async def create_or_update(self, user_id:int, shop:str, city:str, status:str="pending", phone:str|None=None):
    await execute(
        "INSERT INTO sellers(user_id, shop_name, city, status, phone, created_at) "
        "VALUES(%s,%s,%s,%s,%s,NOW()) "
        "ON DUPLICATE KEY UPDATE shop_name=VALUES(shop_name), city=VALUES(city), status=VALUES(status), phone=VALUES(phone)",
        (user_id, shop, city, status, phone)
    )


sellers_repo = SellersRepo()

