from db import fetchone, fetchall, execute


async def create_order(buyer_id: int, seller_id: int, flower_id: int, qty: int, total: int):
    return await execute(
        "INSERT INTO orders(buyer_id,seller_id,flower_id,qty,total_price,status,created_at) "
        "VALUES(%s,%s,%s,%s,%s,'pending_payment',NOW())",
        (buyer_id, seller_id, flower_id, qty, total)
    )


async def get_order(order_id: int):
    return await fetchone("SELECT * FROM orders WHERE id=%s", (order_id,))


async def get_active_order(buyer_id: int):
    return await fetchone(
        "SELECT * FROM orders WHERE buyer_id=%s AND status NOT IN ('completed','rejected','cancelled') "
        "ORDER BY id DESC LIMIT 1",
        (buyer_id,)
    )


async def list_orders(buyer_id: int, status: str | None = None, limit: int = 20):
    if status:
        return await fetchall(
            "SELECT * FROM orders WHERE buyer_id=%s AND status=%s ORDER BY id DESC LIMIT %s",
            (buyer_id, status, limit)
        )
    return await fetchall(
        "SELECT * FROM orders WHERE buyer_id=%s ORDER BY id DESC LIMIT %s",
        (buyer_id, limit)
    )


async def list_orders_by_seller(seller_id: int, status: str | None = None, limit: int = 20):
    if status:
        return await fetchall(
            "SELECT * FROM orders WHERE seller_id=%s AND status=%s ORDER BY id DESC LIMIT %s",
            (seller_id, status, limit)
        )
    return await fetchall(
        "SELECT * FROM orders WHERE seller_id=%s ORDER BY id DESC LIMIT %s",
        (seller_id, limit)
    )


async def set_receipt(order_id: int, receipt_file_id: str):
    await execute(
        "UPDATE orders SET receipt_file_id=%s, status='pending_seller_approval' WHERE id=%s",
        (receipt_file_id, order_id)
    )


async def set_status(order_id: int, status: str):
    await execute("UPDATE orders SET status=%s WHERE id=%s", (status, order_id))


async def set_location(order_id: int, lat: float, lon: float):
    await execute(
        "UPDATE orders SET buyer_location_lat=%s, buyer_location_lon=%s, status='ready_to_ship' WHERE id=%s",
        (lat, lon, order_id)
    )


async def set_address(order_id: int, address: str):
    await execute("UPDATE orders SET buyer_address=%s WHERE id=%s", (address, order_id))


async def mark_shipped(order_id: int):
    await execute("UPDATE orders SET status='shipped', shipped_at=NOW() WHERE id=%s", (order_id,))


async def mark_delivered(order_id: int):
    await execute("UPDATE orders SET status='delivered', delivered_at=NOW() WHERE id=%s", (order_id,))


async def mark_completed(order_id: int):
    await execute("UPDATE orders SET status='completed', completed_at=NOW() WHERE id=%s", (order_id,))
