
from db import fetchone, fetchall, execute

class NeedsRepo:
    async def get_open_needs(self, page:int=1, per_page:int=6):
        offset=(page-1)*per_page
        rows = await fetchall(
            "SELECT id,buyer_id,text,photo_file_id,city,budget,status,created_at "
            "FROM needs WHERE status='open' ORDER BY id DESC LIMIT %s OFFSET %s",
            (per_page, offset)
        )
        total_row = await fetchone("SELECT COUNT(*) as c FROM needs WHERE status='open'")
        total = int(total_row["c"]) if total_row else 0
        return rows, total

    async def get_need(self, need_id:int):
        return await fetchone("SELECT * FROM needs WHERE id=%s", (need_id,))


needs_repo = NeedsRepo()
