
from db import fetchone, fetchall, execute

class NeedOffersRepo:
    async def create_offer(self, need_id:int, seller_id:int, photo_file_id:str, price:int, caption:str|None):
        return await execute(
            "INSERT INTO need_offers(need_id,seller_id,photo_file_id,price,caption,created_at) "
            "VALUES(%s,%s,%s,%s,%s,NOW())",
            (need_id, seller_id, photo_file_id, price, caption)
        )

    async def get_offer(self, offer_id:int):
        return await fetchone("SELECT * FROM need_offers WHERE id=%s", (offer_id,))


need_offers_repo = NeedOffersRepo()
