import time

# simple in-memory busy flags for cPanel single-process usage
_busy = {}  # user_id -> (ts, tag)

TTL = 2.0  # seconds

async def is_busy(user_id:int) -> bool:
    v = _busy.get(user_id)
    if not v:
        return False
    ts, _ = v
    if time.time() - ts > TTL:
        _busy.pop(user_id, None)
        return False
    return True

async def set_busy(user_id:int, tag:str=""):
    _busy[user_id] = (time.time(), tag)

async def clear_busy(user_id:int):
    _busy.pop(user_id, None)


from contextlib import asynccontextmanager

@asynccontextmanager
async def flow_lock(user_id:int, tag:str=''):
    if await is_busy(user_id):
        yield False
        return
    await set_busy(user_id, tag)
    try:
        yield True
    finally:
        await clear_busy(user_id)
