
-- v7.2 patch: orders + chat minimal columns
CREATE TABLE IF NOT EXISTS orders (
  id BIGINT NOT NULL AUTO_INCREMENT,
  buyer_id BIGINT NOT NULL,
  seller_id BIGINT NOT NULL,
  flower_id BIGINT NULL,
  qty INT NOT NULL DEFAULT 1,
  total_price INT NOT NULL DEFAULT 0,
  status VARCHAR(30) NOT NULL DEFAULT 'pending_payment',
  receipt_file_id VARCHAR(255) NULL,
  buyer_lat DECIMAL(10,7) NULL,
  buyer_lon DECIMAL(10,7) NULL,
  buyer_address TEXT NULL,
  delivered_at TIMESTAMP NULL DEFAULT NULL,
  completed_at TIMESTAMP NULL DEFAULT NULL,
  created_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at TIMESTAMP NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  INDEX idx_orders_buyer (buyer_id, status),
  INDEX idx_orders_seller (seller_id, status),
  INDEX idx_orders_status (status)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

ALTER TABLE orders
  ADD COLUMN IF NOT EXISTS qty INT NOT NULL DEFAULT 1,
  ADD COLUMN IF NOT EXISTS total_price INT NOT NULL DEFAULT 0,
  ADD COLUMN IF NOT EXISTS receipt_file_id VARCHAR(255) NULL,
  ADD COLUMN IF NOT EXISTS buyer_lat DECIMAL(10,7) NULL,
  ADD COLUMN IF NOT EXISTS buyer_lon DECIMAL(10,7) NULL,
  ADD COLUMN IF NOT EXISTS buyer_address TEXT NULL,
  ADD COLUMN IF NOT EXISTS delivered_at TIMESTAMP NULL DEFAULT NULL,
  ADD COLUMN IF NOT EXISTS completed_at TIMESTAMP NULL DEFAULT NULL;

