from aiogram.types import ReplyKeyboardMarkup, KeyboardButton


def seller_home_kb():
    return ReplyKeyboardMarkup(
        keyboard=[
            [KeyboardButton(text="🌸 محصولات"), KeyboardButton(text="📦 سفارش‌ها")],
            [KeyboardButton(text="📌 نیازمندی‌ها"), KeyboardButton(text="💬 پیام‌ها و پشتیبانی")],
            [KeyboardButton(text="⚙️ حساب و مالی")],
        ],
        resize_keyboard=True
    )


def seller_products_kb():
    return ReplyKeyboardMarkup(
        keyboard=[
            [KeyboardButton(text="➕ افزودن آگهی"), KeyboardButton(text="📋 آگهی‌های من")],
            [KeyboardButton(text="🗑 غیرفعال/حذف آگهی"), KeyboardButton(text="⬅️ بازگشت به منوی اصلی")],
        ],
        resize_keyboard=True
    )


def seller_orders_kb():
    return ReplyKeyboardMarkup(
        keyboard=[
            [KeyboardButton(text="🆕 سفارش‌های جدید"), KeyboardButton(text="📦 همه سفارش‌ها")],
            [KeyboardButton(text="🟢 سفارش‌های فعال"), KeyboardButton(text="✅ تکمیل‌شده‌ها")],
            [KeyboardButton(text="⬅️ بازگشت به منوی اصلی")],
        ],
        resize_keyboard=True
    )


def seller_needs_kb():
    return ReplyKeyboardMarkup(
        keyboard=[
            [KeyboardButton(text="📌 نیازمندی‌های باز"), KeyboardButton(text="📦 پیشنهادهای من")],
            [KeyboardButton(text="📚 آرشیو نیازمندی‌ها"), KeyboardButton(text="⬅️ بازگشت به منوی اصلی")],
        ],
        resize_keyboard=True
    )


def seller_messages_kb():
    return ReplyKeyboardMarkup(
        keyboard=[
            [KeyboardButton(text="💬 چت‌ها"), KeyboardButton(text="🎫 تیکت‌ها")],
            [KeyboardButton(text="⬅️ بازگشت به منوی اصلی")],
        ],
        resize_keyboard=True
    )


def seller_finance_kb():
    return ReplyKeyboardMarkup(
        keyboard=[
            [KeyboardButton(text="💳 اطلاعات تسویه"), KeyboardButton(text="💰 کمیسیون‌ها")],
            [KeyboardButton(text="👤 مشخصات فروشگاه"), KeyboardButton(text="⬅️ بازگشت به منوی اصلی")],
        ],
        resize_keyboard=True
    )


from aiogram.types import InlineKeyboardMarkup, InlineKeyboardButton

def seller_orders_menu_kb():
    return InlineKeyboardMarkup(inline_keyboard=[
        [InlineKeyboardButton(text="🆕 سفارش‌های جدید", callback_data="sord:new")],
        [InlineKeyboardButton(text="🚚 آماده ارسال", callback_data="sord:ship")],
        [InlineKeyboardButton(text="📋 همه سفارش‌ها", callback_data="sord:all")],
    ])

def seller_order_actions_kb(order_id:int, status:str):
    rows=[]
    if status == "pending_seller_approval":
        rows.append([
            InlineKeyboardButton(text="✅ تایید رسید", callback_data=f"rec_ok:{order_id}"),
            InlineKeyboardButton(text="❌ رد رسید", callback_data=f"rec_no:{order_id}")
        ])
    if status == "ready_to_ship":
        rows.append([InlineKeyboardButton(text="🚚 ارسال شد", callback_data=f"ship:{order_id}")])
    if status == "shipped":
        rows.append([InlineKeyboardButton(text="📦 تحویل شد", callback_data=f"deliv:{order_id}")])
    return InlineKeyboardMarkup(inline_keyboard=rows or [[InlineKeyboardButton(text="🔄 بروزرسانی", callback_data="noop")]])


from aiogram.types import InlineKeyboardMarkup, InlineKeyboardButton

def seller_needs_list_kb(page:int, pages:int):
    nav=[]
    if page>1:
        nav.append(InlineKeyboardButton(text="⬅️ قبلی", callback_data=f"sneeds:{page-1}"))
    if page<pages:
        nav.append(InlineKeyboardButton(text="بعدی ➡️", callback_data=f"sneeds:{page+1}"))
    rows=[]
    if nav:
        rows.append(nav)
    rows.append([InlineKeyboardButton(text="🔍 مشاهده نیازمندی با ID", callback_data="need:pick")])
    return InlineKeyboardMarkup(inline_keyboard=rows)

def seller_need_card_kb(need_id:int):
    return InlineKeyboardMarkup(inline_keyboard=[
        [InlineKeyboardButton(text="📩 ارسال پیشنهاد", callback_data=f"need:offer_quick:{need_id}")],
        [InlineKeyboardButton(text="🧾 مشاهده پیشنهادهای خودم", callback_data="myoffers:1")],
    ])


def seller_listings_home_kb(page:int, pages:int):
    nav=[]
    if page>1:
        nav.append(InlineKeyboardButton(text="⬅️ قبلی", callback_data=f"slist:{page-1}"))
    if page<pages:
        nav.append(InlineKeyboardButton(text="بعدی ➡️", callback_data=f"slist:{page+1}"))
    rows=[]
    if nav:
        rows.append(nav)
    return InlineKeyboardMarkup(inline_keyboard=rows)

def seller_listing_card_kb(flower_id:int, is_active:int):
    toggle_text = "⛔ غیرفعال" if int(is_active)==1 else "✅ فعال"
    return InlineKeyboardMarkup(inline_keyboard=[
        [
            InlineKeyboardButton(text=toggle_text, callback_data=f"lst:toggle:{flower_id}"),
            InlineKeyboardButton(text="📦 موجودی", callback_data=f"lst:stock:{flower_id}"),
            InlineKeyboardButton(text="💰 قیمت", callback_data=f"lst:price:{flower_id}")
        ],
        [
            InlineKeyboardButton(text="🗑 حذف", callback_data=f"lst:del:{flower_id}")
        ]
    ])
