from aiogram.types import InlineKeyboardMarkup, InlineKeyboardButton, ReplyKeyboardMarkup, KeyboardButton

def orders_menu_kb():
    return InlineKeyboardMarkup(inline_keyboard=[
        [InlineKeyboardButton(text="📦 سفارش فعال", callback_data="ord_menu:active")],
        [InlineKeyboardButton(text="📋 همه سفارش‌ها", callback_data="ord_menu:all")],
    ])

def active_order_kb(order_id:int, can_cancel:bool=True, can_resume:bool=True):
    rows=[]
    if can_resume:
        rows.append([InlineKeyboardButton(text="▶️ ادامه سفارش", callback_data=f"ord_resume:{order_id}")])
    if can_cancel:
        rows.append([InlineKeyboardButton(text="❌ لغو سفارش", callback_data=f"ord_cancel:{order_id}")])
    rows.append([InlineKeyboardButton(text="🔄 بروزرسانی", callback_data=f"ord_refresh:{order_id}")])
    return InlineKeyboardMarkup(inline_keyboard=rows)

def receipt_actions_kb(order_id:int):
    return InlineKeyboardMarkup(inline_keyboard=[[
        InlineKeyboardButton(text="✅ تایید رسید", callback_data=f"rec_ok:{order_id}"),
        InlineKeyboardButton(text="❌ رد رسید", callback_data=f"rec_no:{order_id}")
    ]])

def request_location_kb():
    return ReplyKeyboardMarkup(
        keyboard=[[KeyboardButton(text="📍 ارسال لوکیشن", request_location=True)]],
        resize_keyboard=True,
        one_time_keyboard=True
    )

def buyer_delivery_confirm_kb(order_id:int):
    return InlineKeyboardMarkup(inline_keyboard=[[
        InlineKeyboardButton(text="✅ تحویل گرفتم", callback_data=f"buyer_confirm:{order_id}"),
        InlineKeyboardButton(text="⚠️ مشکل دارم", callback_data=f"buyer_issue:{order_id}")
    ]])
