from aiogram.types import ReplyKeyboardMarkup, KeyboardButton


def role_switch_hint_kb():
    # Only a hint. Role switching happens via /buyer /seller /admin
    return ReplyKeyboardMarkup(
        keyboard=[[KeyboardButton(text="/buyer"), KeyboardButton(text="/seller"), KeyboardButton(text="/admin")]],
        resize_keyboard=True
    )


from aiogram.types import InlineKeyboardMarkup, InlineKeyboardButton

def marketplace_nav_kb(page:int, pages:int, mode:str="newest", q:str=""):
    btns=[]
    if page>1:
        btns.append(InlineKeyboardButton(text="⬅️ قبلی", callback_data=f"mp:{mode}:{page-1}:{q}"))
    btns.append(InlineKeyboardButton(text=f"📄 {page}/{pages}", callback_data="noop"))
    if page<pages:
        btns.append(InlineKeyboardButton(text="بعدی ➡️", callback_data=f"mp:{mode}:{page+1}:{q}"))
    return InlineKeyboardMarkup(inline_keyboard=[btns] if btns else [[InlineKeyboardButton(text="📄 1/1", callback_data="noop")]])

def flower_card_kb(flower_id:int, seller_id:int|None=None):
    row1=[
        InlineKeyboardButton(text="🛒 خرید", callback_data=f"buy:{flower_id}"),
        InlineKeyboardButton(text="💬 چت با فروشنده", callback_data=f"chat_seller:{seller_id or 0}:{flower_id}")
    ]
    row2=[
        InlineKeyboardButton(text="⭐ جزئیات فروشنده", callback_data=f"seller:{seller_id or 0}")
    ]
    return InlineKeyboardMarkup(inline_keyboard=[row1,row2])

def search_mode_kb_v7():
    return InlineKeyboardMarkup(inline_keyboard=[
        [InlineKeyboardButton(text="🆕 جدیدترین آگهی‌ها", callback_data="mpmode:newest")],
        [InlineKeyboardButton(text="🔎 جستجو با نام", callback_data="mpmode:name")],
    ])


from aiogram.types import InlineKeyboardMarkup, InlineKeyboardButton

def choose_qty_kb(max_qty:int=5):
    rows=[]
    row=[]
    for i in range(1, max_qty+1):
        row.append(InlineKeyboardButton(text=str(i), callback_data=f"qty:{i}"))
        if len(row)==5:
            rows.append(row); row=[]
    if row: rows.append(row)
    rows.append([InlineKeyboardButton(text="❌ لغو", callback_data="qty_cancel")])
    return InlineKeyboardMarkup(inline_keyboard=rows)

# ---------- Marketplace UI Pro ----------
def marketplace_list_kb(rows:list, page:int, pages:int, mode:str="newest", q:str=""):
    """Compact list: each row has View/Buy/Chat."""
    ik=[]
    for f in rows:
        fid=int(f["id"])
        ik.append([
            InlineKeyboardButton(text="👁 مشاهده", callback_data=f"viewi:{i-1}:{mode}:{page}:{q}"),
            InlineKeyboardButton(text="🛒 خرید", callback_data=f"buy:{fid}"),
            InlineKeyboardButton(text="💬 چت", callback_data=f"chat_seller:{int(f.get('seller_id') or 0)}:{fid}")
        ])
    nav=[]
    if page>1:
        nav.append(InlineKeyboardButton(text="⬅️ قبلی", callback_data=f"mp:{mode}:{page-1}:{q}"))
    nav.append(InlineKeyboardButton(text=f"📄 {page}/{pages}", callback_data="noop"))
    if page<pages:
        nav.append(InlineKeyboardButton(text="بعدی ➡️", callback_data=f"mp:{mode}:{page+1}:{q}"))
    ik.append(nav)
    return InlineKeyboardMarkup(inline_keyboard=ik)

def marketplace_card_kb(flower_id:int, seller_id:int, page:int, pages:int, mode:str="newest", q:str="", name_key:str="", idx:int=0):
    """Single card navigation + actions + similar."""
    row1=[
        InlineKeyboardButton(text="🛒 خرید", callback_data=f"buy:{flower_id}"),
        InlineKeyboardButton(text="💬 چت", callback_data=f"chat_seller:{seller_id}:{flower_id}")
    ]
    row2=[
        InlineKeyboardButton(text="🔎 محصولات مشابه", callback_data=f"sim:{name_key}:{mode}:{page}:{q}"),
        InlineKeyboardButton(text="📋 بازگشت به لیست", callback_data=f"mp:{mode}:{page}:{q}")
    ]
    nav=[]
    if idx>0:
        nav.append(InlineKeyboardButton(text="⬅️ قبلی", callback_data=f"cardnav:{idx-1}:{mode}:{page}:{q}"))
    nav.append(InlineKeyboardButton(text=f"{idx+1}/{pages}", callback_data="noop"))
    if idx < 9:  # within page
        nav.append(InlineKeyboardButton(text="بعدی ➡️", callback_data=f"cardnav:{idx+1}:{mode}:{page}:{q}"))
    return InlineKeyboardMarkup(inline_keyboard=[row1,row2,nav])
