from aiogram.types import ReplyKeyboardMarkup, KeyboardButton


def buyer_home_kb():
    return ReplyKeyboardMarkup(
        keyboard=[
            [KeyboardButton(text="🛒 خرید"), KeyboardButton(text="📦 سفارش‌های من")],
            [KeyboardButton(text="📌 نیازمندی‌ها"), KeyboardButton(text="💬 پیام‌ها و پشتیبانی")],
            [KeyboardButton(text="⚙️ حساب کاربری")],
        ],
        resize_keyboard=True
    )


def buyer_buy_kb():
    return ReplyKeyboardMarkup(
        keyboard=[
            [KeyboardButton(text="🏪 همه آگهی‌های فروش"), KeyboardButton(text="🔎 جستجوی پیشرفته")],
            [KeyboardButton(text="⭐ فروشنده‌های برتر")],
            [KeyboardButton(text="⬅️ بازگشت به منوی اصلی")],
        ],
        resize_keyboard=True
    )
def buyer_orders_kb():
    return ReplyKeyboardMarkup(
        keyboard=[
            [KeyboardButton(text="📦 سفارش‌های من")],
            [KeyboardButton(text="⬅️ بازگشت به منوی اصلی")],
        ],
        resize_keyboard=True
    )


def buyer_needs_kb():
    return ReplyKeyboardMarkup(
        keyboard=[
            [KeyboardButton(text="➕ ثبت نیازمندی"), KeyboardButton(text="📌 نیازمندی‌های من")],
            [KeyboardButton(text="⬅️ بازگشت به منوی اصلی")],
        ],
        resize_keyboard=True
    )


def buyer_messages_kb():
    return ReplyKeyboardMarkup(
        keyboard=[
            [KeyboardButton(text="💬 چت‌ها"), KeyboardButton(text="🎫 تیکت‌ها")],
            [KeyboardButton(text="⬅️ بازگشت به منوی اصلی")],
        ],
        resize_keyboard=True
    )


def buyer_profile_kb():
    return ReplyKeyboardMarkup(
        keyboard=[
            [KeyboardButton(text="👤 مشخصات کاربری"), KeyboardButton(text="ℹ️ راهنما")],
            [KeyboardButton(text="⬅️ بازگشت به منوی اصلی")],
        ],
        resize_keyboard=True
    )


def buyer_main_menu():
    return buyer_home_kb()
