from aiogram import Router, F
from aiogram.types import Message

from services.role_service import role_service
from keyboards.seller import (
    seller_home_kb, seller_products_kb, seller_orders_kb,
    seller_needs_kb, seller_messages_kb, seller_finance_kb
)

from utils.filters import ModeFilter

router = Router()
router.message.filter(ModeFilter('seller'))
router.callback_query.filter(ModeFilter('seller'))


def _not_approved_text():
    return "❌ فقط فروشنده تایید شده. اگر درخواست داده‌اید منتظر تایید ادمین باشید."


@router.message(F.text == "🌸 محصولات")
async def products_menu(message: Message):
    if not await role_service.can_be_seller(message.from_user.id):
        return await message.answer(_not_approved_text())
    await message.answer("🌸 <b>محصولات / آگهی‌ها</b>", reply_markup=seller_products_kb())


@router.message(F.text == "📦 سفارش‌ها")
async def orders_menu(message: Message):
    if not await role_service.can_be_seller(message.from_user.id):
        return await message.answer(_not_approved_text())
    await message.answer("📦 <b>سفارش‌ها</b>", reply_markup=seller_orders_kb())


@router.message(F.text == "📌 نیازمندی‌ها")
async def needs_menu(message: Message):
    if not await role_service.can_be_seller(message.from_user.id):
        return await message.answer(_not_approved_text())
    await message.answer("📌 <b>نیازمندی‌ها و پیشنهادها</b>", reply_markup=seller_needs_kb())


@router.message(F.text == "💬 پیام‌ها و پشتیبانی")
async def messages_menu(message: Message):
    if not await role_service.can_be_seller(message.from_user.id):
        return await message.answer(_not_approved_text())
    await message.answer("💬 <b>پیام‌ها و پشتیبانی</b>", reply_markup=seller_messages_kb())


@router.message(F.text == "⚙️ حساب و مالی")
async def finance_menu(message: Message):
    if not await role_service.can_be_seller(message.from_user.id):
        return await message.answer(_not_approved_text())
    await message.answer("⚙️ <b>حساب و مالی</b>", reply_markup=seller_finance_kb())


@router.message(F.text.contains("بازگشت"))
async def back_home(message: Message):
    await message.answer("🏠 منوی فروشنده", reply_markup=seller_home_kb())


@router.message(F.text == "⬅️ بازگشت به منوی اصلی")
async def seller_back(message: Message):
    await message.answer("🏠 منوی فروشنده:", reply_markup=seller_home_kb())


@router.message(F.text == "➕ افزودن آگهی")
async def add_listing_placeholder(message: Message):
    await message.answer("➕ افزودن آگهی در نسخه بعدی (v7.9) کامل می‌شود. فعلاً از نسخه قبلی افزودن گل استفاده کنید یا بگویید تا همینجا هم اضافه کنم ✅", reply_markup=seller_products_kb())
