from aiogram import Router, F
from aiogram.types import Message

from keyboards.buyer import (
    buyer_home_kb, buyer_buy_kb, buyer_orders_kb,
    buyer_needs_kb, buyer_messages_kb, buyer_profile_kb
)

from utils.filters import ModeFilter

router = Router()
router.message.filter(ModeFilter('buyer'))
router.callback_query.filter(ModeFilter('buyer'))


@router.message(F.text == "🛒 خرید")
async def buy_menu(message: Message):
    await message.answer("🛒 <b>خرید گل</b>\n\nیک گزینه را انتخاب کنید:", reply_markup=buyer_buy_kb())


@router.message(F.text == "📦 سفارش‌های من")
async def orders_menu(message: Message):
    await message.answer("📦 <b>سفارش‌های من</b>", reply_markup=buyer_orders_kb())


@router.message(F.text == "📌 نیازمندی‌ها")
async def needs_menu(message: Message):
    await message.answer("📌 <b>نیازمندی‌ها</b>", reply_markup=buyer_needs_kb())


@router.message(F.text == "💬 پیام‌ها و پشتیبانی")
async def messages_menu(message: Message):
    await message.answer("💬 <b>پیام‌ها و پشتیبانی</b>", reply_markup=buyer_messages_kb())


@router.message(F.text == "⚙️ حساب کاربری")
async def profile_menu(message: Message):
    await message.answer("⚙️ <b>حساب کاربری</b>", reply_markup=buyer_profile_kb())


@router.message(F.text.contains("بازگشت"))
async def back_home(message: Message):
    await message.answer("🏠 منوی اصلی", reply_markup=buyer_home_kb())


@router.message(F.text == "⬅️ بازگشت به منوی اصلی")
async def back_home(message: Message):
    await message.answer("🏠 منوی اصلی", reply_markup=buyer_home_kb())
