
from aiogram import Router, F
from aiogram.types import Message
from utils.filters import ModeFilter
from config import settings
from keyboards.admin import admin_home_kb

router = Router()
router.message.filter(ModeFilter('admin'))

def is_admin(uid:int)->bool:
    return uid in settings.ADMIN_IDS

@router.message(F.text.in_({"/start","/admin"}))
async def admin_start(message: Message):
    if not is_admin(message.from_user.id):
        return
    await message.answer("🅰️ پنل ادمین", reply_markup=admin_home_kb())

@router.message()
async def admin_fallback(message: Message):
    if not is_admin(message.from_user.id):
        return
    if message.text and message.text.startswith("/"):
        return
    await message.answer("🅰️ پنل ادمین", reply_markup=admin_home_kb())
