import os
from dotenv import load_dotenv

BASE_DIR = os.path.dirname(os.path.abspath(__file__))
load_dotenv(os.path.join(BASE_DIR, ".env"))

class Settings:
    BOT_TOKEN: str = os.getenv("BOT_TOKEN", "").strip()
    ADMIN_IDS = [int(x.strip()) for x in os.getenv("ADMIN_IDS", "").split(",") if x.strip()]

    DB_HOST: str = os.getenv("DB_HOST", "localhost")
    DB_PORT: int = int(os.getenv("DB_PORT", "3306"))
    DB_USER: str = os.getenv("DB_USER", "")
    DB_PASS: str = os.getenv("DB_PASS", "")
    DB_NAME: str = os.getenv("DB_NAME", "")

    FASTAPI_PORT: int = int(os.getenv("FASTAPI_PORT", "8000"))
    COMMISSION_PERCENT: int = int(os.getenv("COMMISSION_PERCENT", "5"))
    PAYMENT_TIMEOUT_MIN: int = int(os.getenv("PAYMENT_TIMEOUT_MIN", "30"))
    REQUEST_EXPIRE_H: int = int(os.getenv("REQUEST_EXPIRE_H", "24"))

settings = Settings()
