from aiogram import Bot, Dispatcher
from aiogram.client.default import DefaultBotProperties

from config import settings
from utils.middleware import BusyLockMiddleware, RoleGuardMiddleware

from handlers.common import router as common_router
from handlers.buyer.menu import router as buyer_menu_router
from handlers.buyer.marketplace import router as buyer_marketplace_router
from handlers.buyer.orders import router as buyer_orders_router
from handlers.seller.menu import router as seller_menu_router
from handlers.seller.needs import router as seller_needs_router
from handlers.seller.listings import router as seller_listings_router
from handlers.admin.menu import router as admin_menu_router
from handlers.admin.sellers import router as admin_sellers_router

bot = Bot(token=settings.BOT_TOKEN, default=DefaultBotProperties(parse_mode="HTML"))

dp = Dispatcher()

dp.update.middleware(BusyLockMiddleware())

# routers

dp.include_router(common_router)

dp.include_router(buyer_menu_router)

dp.include_router(buyer_marketplace_router)

dp.include_router(buyer_orders_router)

dp.include_router(seller_menu_router)

dp.include_router(seller_needs_router)
dp.include_router(seller_listings_router)

dp.include_router(admin_menu_router)
dp.include_router(admin_sellers_router)


async def start_bot():
    await dp.start_polling(bot, polling_timeout=20, request_timeout=10)
